module L = struct
  open Ga_types



  let gvars = Ga_cfg.read_config "general.cfg"
  let agfile = stdout

  type data = float array
	
  type user_data= unit
  type result = unit
  exception Fin_AG

      

  let scale data =
    let newdata=Array.copy data in
    for i=0 to Func.dim -1 do
      newdata.(i)<- if data.(i)>Func.highbound then data.(i)-.Func.delta
	else if data.(i)<Func.lowbound then data.(i)+.Func.delta 
	else data.(i) 
    done;
    newdata
      
  let nb_evals_ag = ref 0

  let eval u numgen data = 
    incr nb_evals_ag;
    (Lazy.lazy_from_val (Func.f_x  data))
      
  let generate u numgen = 
    scale (Array.init Func.dim (fun i -> ((Random.float Func.delta)+.Func.lowbound)))


  let cross u numgen a b = 
    let newa = Array.copy a
    and newb = Array.copy b  in
    let alpha=(Random.float 2.) -.0.5 in
    for i=0 to Func.dim-1 do
      newa.(i) <- (alpha*. a.(i) +. (1.-.alpha)*. b.(i));
      newb.(i) <- (alpha*. b.(i) +. (1.-.alpha)*. a.(i));
    done;
    ((scale newa),(scale newb))
      
  let mutate u numgen a = 
    let newa=Array.copy a in
    let coeff=Random.float 1. in
    for i=0 to Func.dim-1 do 
      let noise =coeff*.((Random.float Func.delta) -.Func.delta/.2.) in
      let noise=coeff*.(Random.float 1.)-.0.5 in 
      newa.(i) <- a.(i)+. noise;
    done;
    (scale newa)
	
  let distance u d1 d2 = 
    let sum=ref 0. in
    for i=0 to Func.dim-1 do
      sum:= !sum+. (d1.(i)-.d2.(i))*.(d1.(i)-.d2.(i))
    done;
    sqrt (!sum/.(float Func.dim))
      
      
  let barycenter u d1 n1 d2 n2 = 
    let f1=float n1 and f2=float n2 in
    let g=Array.init Func.dim (fun i-> 0.) in
    for i=0 to Func.dim-1 do
      g.(i) <- ((f1*. d1.(i) +. f2*. d2.(i))/.(f1+. f2))
    done;
    g
      
  let computeRMeanSigmaBestMaxfMinf pop = 
    let sum = ref 0.0 and sum2= ref 0.0 and best = ref 0 in 
    for i = 0 to Array.length pop - 1 do 
      let v = Lazy.force pop.(i).r_fit in
      sum := !sum +. v ;
      sum2 := !sum2 +. v *. v;
      if (v > Lazy.force pop.(!best).r_fit) then best:=i
    done; 
    let fn = float (Array.length pop) in
    let sum = !sum /. fn in
    let sum2 = sqrt (!sum2 /. fn -. sum *. sum) in
    (sum, sum2, !best)
      
  let init u = 
    Random.init gvars.seed

  let prepare_ag u pop = ()

  let prepare_gen u numgen pop = ()

  let count = ref 1 
  let after_scale u numgen pop best = 
    decr count;
    if (numgen mod Func.stepgen)=0 or (Func.disp) then
      begin
	Printf.fprintf agfile "Generation %d\n" numgen; 
	for i=0 to Func.dim-1 do
	  Printf.fprintf agfile "v(%d)=%f " i best.data.(i);
	done;
	Printf.fprintf agfile "val= %f\n" (Lazy.force best.r_fit);
	flush agfile
      end;
    if Func.disp && (!count=0) then
      begin
	Graph.reset ();
	for i = 0 to Array.length pop - 1 do 
	  Graph.display pop.(i).data
	done;
	count := Graph.wait()
      end

  let after_share u numgen pop  clus = 
    if (numgen mod Func.stepgen)=0 or (Func.disp) then 
      (Printf.fprintf agfile "nb of best/clusters=%d/%d\n" clus.optima clus.clusters;
       flush agfile)

  let after_reproduce u numgen pop prot = ()
      
  let after_gen u numgen pop = 
    ()
      
  let terminate_ag u pop1 best_elems nb_done = ()
      
end

module M = Ga_optimize.Make(L);;

let _ = 
  if Func.disp then ignore (Graph.init ());
  try M.opti () with Exit -> ();;

