open Expr_type

let string2expr fun_string =
  let lexbuf = Lexing.from_string fun_string in
  Parser.main Lexer.token lexbuf

(*-------------------*)

let float_op binary_op=
  match binary_op with
    | Plus -> (+.)
    | Minus -> (-.)
    | Mult -> ( *. )
    | Div -> (/.)
    | PowF -> ( ** )

let int_op binary_op=
  match binary_op with
    | Plus -> (+)
    | Minus -> (-)
    | Mult -> ( * )
    | Div -> (/)
    | _-> failwith "int_op"

let exec_unop unary_op =
  match unary_op with
      Cos -> cos
    | Sin -> sin
    | Tan -> tan
    | Log -> log
    | Exp -> exp
    | Sqrt -> sqrt
    | Abs -> abs_float
    | _-> failwith "exec_unop"


let indice ioption =
  match ioption with Some i -> i | None -> failwith "indice"


let rec int_of_indice x ioption v = 
  match v with
    | N -> Array.length x
    | I -> indice ioption
    | Int i -> i
    | IBinOp (op,a,b) ->
	(int_op op) (int_of_indice x ioption a) (int_of_indice x ioption b)
(*    | _-> failwith "int_of_indice" *)

let var_indice x ioption ind=
  (* Attention ! Evaluation comme indice du tableau de variables:
     i devient (i-1).
     Si 'i' apparait dans la formule, c'est 'float_of_indice' qu'il
     faut utiliser.*)
  (int_of_indice x ioption ind)-1
(*
  match ind with
      Int j -> j-1
    | N -> Array.length x -1
    | I -> indice ioption -1
    | IBinOp (op,a,b) ->
	(int_op op) (var_indice x ioption a) (var_indice x ioption b)
*)

let float_of_indice x ioption v = float (int_of_indice x ioption v)

let several evali binary_op ind_i ind_j x expr =
  let i= int_of_indice x None ind_i
  and j= int_of_indice x None ind_j in
  let i,j= if i<=j then (i,j) else (j,i) in
  let rec loop k =
    if k>=j then evali expr x (Some j)
    else binary_op (evali expr x (Some k)) (loop (k+1)) in
  loop i

let rec evali expr x ioption=
  match expr with
      Float v -> v
    | Var ind -> x.(var_indice x ioption ind)
    | Ind ind -> float_of_indice x ioption ind
    | BinOp (op,a,b) -> (float_op op) (evali a x ioption) (evali b x ioption)
    | UnOp (Uminus,a) -> -. evali a x ioption
    | UnOp (op,a) -> (exec_unop op) (evali a x ioption)
    | Sum (a,b, expr) -> several evali (+.) a b x expr
    | Prod (a,b, expr) -> several evali ( *. ) a b x expr
    | PowI (e,k) ->
	let v= evali e x ioption in
	let rec pow v p =
	  if p=0 then 1.
	  else v*.pow v (p-1) in
	if k<0 then 1./.pow v (-k) else pow v k

let rec eval expr x = evali expr x None


(*-----------------------*)

open Interval

let interval_op binary_op=
  match binary_op with
    | Plus -> (+$)
    | Minus -> (-$)
    | Mult -> ( *$ )
    | Div -> (/$)
    | PowF -> failwith "interval_op: PowF not implemented"

let interval_float_op binary_op=
  match binary_op with
    | Plus -> (+$.)
    | Minus -> (-$.)
    | Mult -> ( *$. )
    | Div -> (/$.)
    | PowF -> failwith "interval_float_op: PowF not implemented"

let interval_unop unary_op =
  match unary_op with
      Cos -> cos_I
    | Sin -> sin_I
    | Log -> log_I
    | Exp -> exp_I
    | Sqrt -> sqrt_I
    | _->failwith "interval_unop"


let rec range_i expr xbounds ioption=
    match expr with
      Float v -> {Interval.low=v;Interval.high=v}
    | Var ind ->
	let i= var_indice xbounds ioption ind in
	let (lb,ub)=xbounds.(i) in
	{Interval.low=lb;Interval.high=ub}
    | Ind ind -> 
	let v= float_of_indice xbounds ioption ind in
	{Interval.low=v;Interval.high=v}
    | BinOp (Div,Float v,b) ->
	(/.$) v (range_i b xbounds ioption)
    | BinOp (Minus,Float v,b) ->
	((~-$) (range_i b xbounds ioption)) +$. v
    | BinOp (op,a,Float v) ->
	(interval_float_op op) (range_i a xbounds ioption) v
    | BinOp (op,Float v,b) ->
	(interval_float_op op) (range_i b xbounds ioption) v

    | BinOp (Div,Ind ind,b) ->
	let v= float_of_indice xbounds ioption ind in
        (/.$) v (range_i b xbounds ioption)
    | BinOp (op,a,Ind ind) ->
	let v= float_of_indice xbounds ioption ind in
	(interval_float_op op) (range_i a xbounds ioption) v
    | BinOp (op,Ind ind,b) ->
	let v= float_of_indice xbounds ioption ind in
	(interval_float_op op) (range_i b xbounds ioption) v

    | BinOp (op,a,b) ->
	(interval_op op) (range_i a xbounds ioption) (range_i b xbounds ioption)
    | UnOp (Uminus,a) -> (~-$) (range_i a xbounds ioption)
    | UnOp (Tan,a) ->
	let range_a= range_i a xbounds ioption in
	(sin_I range_a) /$ (cos_I range_a)
    | UnOp (op,a) -> (interval_unop op) (range_i a xbounds ioption)

    | Sum (a,b, expr) -> several range_i (+$) a b xbounds expr
    | Prod (a,b, expr) ->  several range_i ( *$ ) a b xbounds expr
    | PowI (e,k) -> Interval.pow_I_i (range_i e xbounds ioption) k

(*let range expr xbounds= range_i expr xbounds None*)

let range expr xbounds= 
  let tmp = Array.init (Array.length xbounds) (fun i -> (xbounds.(i).Interval.low,xbounds.(i).Interval.high)) in
  range_i expr tmp None
