open Interval;;

let rndg () = Random.float 2.0 -. 1.0;;

let matrot dim = 
  let m = Array.create_matrix dim dim 0.0 in
  
  for i = dim-1 downto 0 do
    for j = dim-1 downto 0 do
      m.(i).(j)<-rndg ()
    done
  done;
  
  for i = dim-1 downto 0 do
    for j = dim-1 downto i+1 do
      let dp = ref 0.0 in
      for k = dim-1 downto 0 do
	dp := !dp +. m.(i).(k)*.m.(j).(k)
      done;
      for k = dim-1 downto 0 do
	m.(i).(k)<- m.(i).(k) -. !dp *. m.(j).(k)
      done;
    done;
    let dp = ref 0.0 in
    for k = dim-1 downto 0 do
      dp:= !dp +. m.(i).(k) *. m.(i).(k)
    done;
    if !dp<=0.0 then failwith "linear dependancy";
    dp := 1.0 /. (sqrt !dp);
    for k = dim-1 downto 0 do
      m.(i).(k) <- m.(i).(k)*. !dp;
    done;
  done;
  m
      
(* Multiplication Matrice X Vecteur de flottants*)
      
let mult_mat_F a x =
  let y = Array.create (Array.length a) 0. in
  for i=0 to (Array.length a)-1 do
    for j=0 to (Array.length a.(i))-1 do
      y.(i)<-y.(i) +. a.(i).(j) *. x.(j)
    done;
  done;
  y

(* Multiplication Matrice X Vecteur d'intervalles *)

let mult_mat_I a x =
  let y = Array.create (Array.length a) {low=0.;high=0.} in
  for i=0 to (Array.length a)-1 do
    for j=0 to (Array.length a.(i))-1 do
      y.(i)<-y.(i) +$ (x.(j) *$. a.(i).(j))
    done;
  done;
  y

let rotated_F mrot f_F =
  fun x -> f_F (mult_mat_F mrot x)

let rotated_I mrot f_I =
  fun x -> f_I (mult_mat_I mrot x)


