open Expr_type

let string2expr fun_string =
  let lexbuf = Lexing.from_string fun_string in
  Parser.main Lexer.token lexbuf

(*-------------------*)

let float_op binary_op=
  match binary_op with
    | Plus -> (+.)
    | Minus -> (-.)
    | Mult -> ( *. )
    | Div -> (/.)
    | PowF -> ( ** )

let int_op binary_op=
  match binary_op with
    | Plus -> (+)
    | Minus -> (-)
    | Mult -> ( * )
    | Div -> (/)
    | _-> failwith "int_op"

let exec_unop unary_op =
  match unary_op with
      Cos -> cos
    | Sin -> sin
    | Tan -> tan
    | Log -> log
    | Exp -> exp
    | Sqrt -> sqrt
    | Abs -> abs_float
    | _-> failwith "exec_unop"


let indice ioption =
  match ioption with Some i -> i | None -> failwith "indice"


let rec int_of_indice x ioption v = 
  match v with
    | N -> Array.length x
    | I -> indice ioption
    | Int i -> i
    | IBinOp (op,a,b) ->
	(int_op op) (int_of_indice x ioption a) (int_of_indice x ioption b)
(*    | _-> failwith "int_of_indice" *)

let var_indice x ioption ind=
  (* Attention ! Evaluation comme indice du tableau de variables:
     i devient (i-1).
     Si 'i' apparait dans la formule, c'est 'float_of_indice' qu'il
     faut utiliser.*)
  (int_of_indice x ioption ind)-1
(*
  match ind with
      Int j -> j-1
    | N -> Array.length x -1
    | I -> indice ioption -1
    | IBinOp (op,a,b) ->
	(int_op op) (var_indice x ioption a) (var_indice x ioption b)
*)

let float_of_indice x ioption v = float (int_of_indice x ioption v)

let several evali binary_op ind_i ind_j x expr =
  let i= int_of_indice x None ind_i
  and j= int_of_indice x None ind_j in
  let i,j= if i<=j then (i,j) else (j,i) in
  let rec loop k =
    if k>=j then evali expr x (Some j)
    else binary_op (evali expr x (Some k)) (loop (k+1)) in
  loop i

let rec evali expr x ioption=
  match expr with
      Float v -> v
    | Var ind -> x.(var_indice x ioption ind)
    | Ind ind -> float_of_indice x ioption ind
    | BinOp (op,a,b) -> (float_op op) (evali a x ioption) (evali b x ioption)
    | UnOp (Uminus,a) -> -. evali a x ioption
    | UnOp (op,a) -> (exec_unop op) (evali a x ioption)
    | Sum (a,b, expr) -> several evali (+.) a b x expr
    | Prod (a,b, expr) -> several evali ( *. ) a b x expr
    | PowI (e,k) ->
	let v= evali e x ioption in
	let rec pow v p =
	  if p=0 then 1.
	  else v*.pow v (p-1) in
	if k<0 then 1./.pow v (-k) else pow v k

let rec eval expr x = evali expr x None


