
type binary_op= Plus | Minus | Mult | Div | PowF;;

type unary_op= Uminus | Cos | Sin | Tan | Log | Exp | Sqrt | Abs;;

type indice=
  | N
  | I
  | Int of int
  | IBinOp of (binary_op * indice * indice)
;;

type expr =
  | Float of float
  | Var of indice
  | Ind of indice
  | UnOp of (unary_op*expr)
  | BinOp of (binary_op*expr*expr)
  | Sum of (indice*indice*expr)
  | Prod of (indice*indice*expr)
  | PowI of (expr*int)
;;
(* Type of arithmetic expression.*)


val string2var: string -> expr

val string2var2: string -> indice -> expr
