let size=500;;
let maxi = ref (-1./.0.) and mini = ref (1./.0.);;

let max_col=256;;
let (red,green,blue) = 
  let red = Array.create max_col 0
  and blue = Array.create max_col 0
  and green = Array.create max_col 0 in
  for i=0 to max_col-1 do
    red.(i)<-(i/64)*64;
    green.(i)<-((i/8) mod 8)*32;
    blue.(i)<-(i mod 8)*32;
  done;
  (red,green,blue);;

let max_col=768;;
let (red,green,blue) = 
  let red = Array.create max_col 0
  and blue = Array.create max_col 0
  and green = Array.create max_col 0 in
  for i=0 to max_col-1 do
    if i<256 then (
      red.(i)<-0;
      blue.(i)<-i)
    else if i<512 then (
      red.(i)<-i mod 256;
      blue.(i)<-255)
    else (
      red.(i)<-255;
      blue.(i)<-255 - (i mod 256))
  done;
  (red,green,blue);;

let max_col=7*256;;
let (red,green,blue) = 
  let red = Array.create max_col 0
  and blue = Array.create max_col 0
  and green = Array.create max_col 0 in
  for i=0 to max_col-1 do
    if i<256 then (
      red.(i)<-0;
      blue.(i)<-i/2+128)
    else if i<2*256 then (
      red.(i)<-i mod 256;
      blue.(i)<-255)
    else if i<3*256 then (
      red.(i)<-255;
      blue.(i)<-255 - (i mod 256))
    else if i< 4*256 then(
      red.(i)<-255;
      green.(i)<-i mod 256)
    else if i<5*256 then (
      red.(i)<-255-(i mod 256);
      green.(i)<-255)
    else if i<6*256 then (
      green.(i)<-255;
      blue.(i)<-i mod 256)
    else (
      green.(i)<-255;
      blue.(i)<-255;
      red.(i)<-i mod 256)
  done;
  (red,green,blue);;

let find_color f = 
  let f = (f -. !mini) /. (!maxi -. !mini) in
  let r = int_of_float ((float max_col) *. f) in
  let r = if r>=max_col then max_col-1 else if r<0 then 0 else r in
  Graphics.rgb red.(r) green.(r) blue.(r);;

let wait () = 
  let st = 
    Graphics.wait_next_event [Graphics.Button_down;Graphics.Key_pressed] in
  if not st.Graphics.keypressed then 1 
  else
    let c = st.Graphics.key in 
    if c = 'Q' then raise Exit;
    let a = (int_of_char c)-(int_of_char '0') in
    if (a<0) or (a>9) then 1 else if a =0 then 10 else a;;

let init () = 
  let x = Array.create 2 0.0 in
  for i = 0 to size-1 do
    x.(0) <- Func.lowbound +. Func.delta *. (float i)/.(float size);
    for j = 0 to size-1 do
      x.(1) <- Func.lowbound +. Func.delta *. (float j)/.(float size);
      let f = (Func.f_x x) in
      if f> !maxi then maxi:=f;
      if f< !mini then mini:=f;
    done
  done;
  Graphics.open_graph " 500x500";
      (*      Graphics.resize_window size size;*)
  Graphics.clear_graph ();
      (*  Graphics.auto_synchronize false;*)
  Graphics.display_mode false;
  for i = 0 to size-1 do
    x.(0) <- Func.lowbound +. Func.delta *. (float i)/.(float size);
    for j = 0 to size-1 do
      x.(1) <- Func.lowbound +. Func.delta *. (float j)/.(float size);
      let f = (Func.f_x x) in
      let c = find_color f in
      Graphics.set_color c;
      Graphics.plot i j;
    done
  done;
  Graphics.synchronize ();
  Graphics.display_mode true;
  Graphics.remember_mode false;
  Graphics.set_color 0;
  wait();;


      
let reset () = 
  Graphics.synchronize();;

let display x = 
  let i = int_of_float ((x.(0) -. Func.lowbound) /. Func.delta *. (float size)) in
  let j = int_of_float ((x.(1) -. Func.lowbound) /. Func.delta *. (float size)) in
  if i>=0 && i<size && j>=0 && j<size then 
    begin
      Graphics.fill_circle i j 5
    end;;

  
