let rdim = ref 2
let rseed = ref 0
let rhighbound = ref 20.
let rlowbound = ref (-20.)
let rfunc = ref 1
let rstepgen = ref 100
let rdisp = ref true
let rinct = ref 0.1
let rdep = ref 5.0
let rddep = ref 1.0
let rexpr= ref "sum(1,n,(xi^2/4000.))-prod(1,n,cos(xi/sqrt(i)))+1."

let bool_of_string x = x = "true"
module Map_strings =
  Map.Make(struct
    type t = string
    let compare x y = compare x y
  end)

let map file = 
  let m = ref Map_strings.empty
  and inch = open_in file
  and sep = Str.regexp "[ \t=]+" in
  try
    while true do
      let st = input_line inch in
      let sttab = Array.of_list (Str.split sep st) in
      if Array.length sttab >= 2
      then m := Map_strings.add sttab.(0) sttab.(1) !m;
    done;
    failwith "cfg.map: Unreachable"
  with End_of_file -> close_in inch; !m;;

let _ = 
  let map = map "func.cfg" in
  let find_val s = 
    let r = Map_strings.find s map in
    Printf.printf "%s = %s\n" s r;
    flush stdout;
    r in
  let find_string v x = try v:=(find_val x) with _ -> ()
  and find_float v x = try v:=float_of_string (find_val x) with _ -> ()
  and find_int v x = try v:=int_of_string (find_val x) with _ -> ()
  and find_bool v x = try v:=bool_of_string (find_val x) with _ -> () in
  find_bool rdisp "disp";
  find_int rdim "dim";
  find_int rseed "seed";
  find_int rfunc "func";
  find_int rstepgen "step";
  find_string rexpr "expr";
  find_float rinct "inct";
  find_float rdep "dep";
  find_float rddep "ddep";
  find_float rhighbound "high";
  find_float rlowbound "low";;



let anon_fun d = ();;
let _ = 
  Arg.parse [
    ("-disp",Arg.Unit (fun () -> rdisp:=true),": set disp to true (default false; usable only with dim=2)");
    ("-dim",Arg.Set_int rdim,"dim : set dimension to dim (default 2)");
    ("-func",Arg.Set_int rfunc,"f : set func number to f (default 1, 0 to use value of expr)");
    ("-step",Arg.Set_int rstepgen,"num : set stepgen to num (default 100)");
    ("-seed",Arg.Set_int rseed,"seed : set seed  (default 0)");
    ("-expr",Arg.Set_string rexpr,"s : set expression to s (default:\"sum(1,n,(xi^2/4000.))-prod(1,n,cos(xi/sqrt(i)))+1.)\"");
    ("-inct",Arg.Set_float rinct,"inct : set inct (default 0.1)");
    ("-dep",Arg.Set_float rdep,"high : set dep (default 5.0)");
    ("-ddep",Arg.Set_float rddep,"high : set ddep (default 1.0)");
    ("-high",Arg.Set_float rhighbound,"high : set highbound to high (default 20)");
    ("-low",Arg.Set_float rlowbound,"high : set lowbound to low (default -20)")
  ] anon_fun "Programme d'optimisation AG\n (C) JM Alliot/N Durand/D Gianazza/JB Gotteland (2012)";;

let dim = if !rdim<1 then failwith "dim>=1" else !rdim
let seed = !rseed
let highbound = !rhighbound
let lowbound  = if !rlowbound>=highbound then failwith "lowbound<=highbound" else !rlowbound
let func = !rfunc
let stepgen = if !rstepgen<1 then failwith "stepgen>=1" else !rstepgen
let disp= !rdisp && (dim=2)
let inct = !rinct
let dep = !rdep
let ddep = !rddep
let expr = if func=0 then Expr.eval (Expr.string2expr !rexpr)
  else Expr.eval (Expr.string2expr "sum(1,n,(xi^2/4000.))-prod(1,n,cos(xi/sqrt(i)))+1.")



let delta=highbound -. lowbound
let pi = acos (-1.0)
let mrot=   
  Rotate.matrot dim 

(* [0,pi] *)
let micha_x v = 
  let m = 10 in
  let s1 = ref 0.0 in 
  for i= 0 to (Array.length v)-1 do
    s1:= !s1+. (sin v.(i)) *. (sin (v.(i)*.v.(i)*.(float (i+1))/.pi))**(2.0*.(float m));
  done;
  ((float dim)+. !s1);;

(* [-500,500] Fonction sans intérêt*)
let schwefel_x v = 
  let s1 = ref 0.0 in
  for i= 0 to (Array.length v)-1 do
    s1:= !s1+. v.(i)*. (sin (sqrt (abs_float v.(i))));
  done;
(*  !s1+.((float dim)*.(max (abs_float highbound) (abs_float lowbound)));;*)
  let sum = 418.9829*.(float dim) -. !s1 in
  1./.(1.+. sum);;

(* [-4.12,6.12] *)
let rastrigin_x v = 
  let s1 = ref 0.0 in
  for i= 0 to (Array.length v)-1 do
    s1:= !s1+. 10.0 +. v.(i) *. v.(i) -. 10.0*.(cos (2.*.pi*.v.(i)));
  done;
  1./.(1.+. !s1);;

(* [-4.12,6.12] *)
let ackley_x v = 
  let a = 20.0 and b=0.2 and c=2.*.pi in
  let s1 = ref 0.0 and s2 = ref 0. in 
  for i= 0 to (Array.length v)-1 do
    s1:= !s1+. v.(i) *. v.(i);
    s2 := !s2 +. (cos (c*.v.(i)))
  done;
  let sum = -.a*.(exp (-.b*.(sqrt (!s1/.(float dim)))))-.(exp (!s2/.(float dim)))
    +.a+.(exp 1.) in
  1./.(1.+. sum);;

(* [-400,600] *)
let griewank_x v = 
  let s1 = ref 0.0 and s2 = ref 1.0 and sum=ref 0.0 in
  for i= 0 to (Array.length v)-1 do
    s1:= !s1+. v.(i)*. v.(i);
    s2:= !s2*. (cos (v.(i)/. (sqrt (float (i+1)))))
  done;
  sum := !s1/. 4000.0 -. !s2 +.1.;
  1./.(1.+. !sum)
    
let helice_x p =
  let n=5. and  k=1.1 in
  let x=p.(0) and y=p.(1) in
  let teta=atan2 y x
  and r= sqrt (x*.x+.y*.y) in
  (1./.(1.+.r*.((cos (n*.r+.teta))+.k)))

let f_x= 
  match func with
    0 -> expr
  | 1 -> griewank_x
  | 2 -> Rotate.rotated_F mrot griewank_x
  | 3 -> ackley_x
  | 4 -> Rotate.rotated_F mrot ackley_x
  | 5 -> rastrigin_x
  | 6 -> Rotate.rotated_F mrot rastrigin_x
  | 7 -> schwefel_x
  | 8 -> Rotate.rotated_F mrot schwefel_x
  | 9 -> micha_x
  |10 -> Rotate.rotated_F mrot micha_x
  |11 -> helice_x
  |12 -> Rotate.rotated_F mrot helice_x
  | _ -> failwith "Undefined function selector";;

