(*
    Copyright 2011 Jean-Marc Alliot

    This file is part of the mpfi/mpfr bindings.

    The mpfi/mpfr bindings is free software: 
    you can redistribute it and/or modify it under the terms of 
    the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The mpfi/mpfr bindings is distributed in the hope that it will be 
    useful,but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public 
    License along with the mpfi/mpfr bindings.  
    If not, see <http://www.gnu.org/licenses/>.
*)

type t
type rounding = RNDN | RNDZ | RNDU | RNDD | RNDA
external init : unit -> t = "caml_mpfr_init"
external init2 : int -> t = "caml_mpfr_init2"
external mpfr_set_default_prec : int -> unit = "caml_mpfr_set_default_prec"
external mpfr_get_default_prec : unit -> int = "caml_mpfr_get_default_prec"
external mpfr_set_prec : t -> int -> unit = "caml_mpfr_set_prec"
external mpfr_get_prec : t -> int = "caml_mpfr_get_prec"
external set : t -> t -> rounding -> int = "caml_mpfr_set"
external set_d : t -> float -> rounding -> int = "caml_mpfr_set_d"
external set_str : t -> string -> int -> rounding -> int
  = "caml_mpfr_set_str"
external add : t -> t -> t -> rounding -> int = "caml_mpfr_add"
external sub : t -> t -> t -> rounding -> int = "caml_mpfr_sub"
external mul : t -> t -> t -> rounding -> int = "caml_mpfr_mul"
external div : t -> t -> t -> rounding -> int = "caml_mpfr_div"
external neg : t -> t -> rounding -> int = "caml_mpfr_neg"
external sqr : t -> t -> rounding -> int = "caml_mpfr_sqr"
external sqrt : t -> t -> rounding -> int = "caml_mpfr_sqrt"
external abs : t -> t -> rounding -> int = "caml_mpfr_abs"
external log : t -> t -> rounding -> int = "caml_mpfr_log"
external exp : t -> t -> rounding -> int = "caml_mpfr_exp"
external exp2 : t -> t -> rounding -> int = "caml_mpfr_exp2"
external cos : t -> t -> rounding -> int = "caml_mpfr_cos"
external sin : t -> t -> rounding -> int = "caml_mpfr_sin"
external tan : t -> t -> rounding -> int = "caml_mpfr_tan"
external acos : t -> t -> rounding -> int = "caml_mpfr_acos"
external asin : t -> t -> rounding -> int = "caml_mpfr_asin"
external atan : t -> t -> rounding -> int = "caml_mpfr_atan"
external acosh : t -> t -> rounding -> int = "caml_mpfr_acosh"
external asinh : t -> t -> rounding -> int = "caml_mpfr_asinh"
external atanh : t -> t -> rounding -> int = "caml_mpfr_atanh"
external cosh : t -> t -> rounding -> int = "caml_mpfr_cosh"
external sinh : t -> t -> rounding -> int = "caml_mpfr_sinh"
external tanh : t -> t -> rounding -> int = "caml_mpfr_tanh"
external log1p : t -> t -> rounding -> int = "caml_mpfr_log1p"
external expm1 : t -> t -> rounding -> int = "caml_mpfr_expm1"
external log2 : t -> t -> rounding -> int = "caml_mpfr_log2"
external log10 : t -> t -> rounding -> int = "caml_mpfr_log10"
external add_d : t -> t -> float -> rounding -> int = "caml_mpfr_add_d"
external sub_d : t -> t -> float -> rounding -> int = "caml_mpfr_sub_d"
external mul_d : t -> t -> float -> rounding -> int = "caml_mpfr_mul_d"
external div_d : t -> t -> float -> rounding -> int = "caml_mpfr_div_d"
external d_sub : t -> float -> t -> rounding -> int = "caml_mpfr_d_sub"
external d_div : t -> float -> t -> rounding -> int = "caml_mpfr_d_div"
external get_d : t -> int -> float = "caml_mpfr_get_d"
external const_log2 : t -> rounding -> int = "caml_mpfr_const_log2"
external const_pi : t -> rounding -> int = "caml_mpfr_const_pi"
external const_euler : t -> rounding -> int = "caml_mpfr_const_euler"
external cmp : t -> t -> int = "caml_mpfr_cmp"
external cmp_d : t -> float -> int = "caml_mpfr_cmp_d"
external cmp_abs : t -> t -> int = "caml_mpfr_cmp_abs"
external nan_p : t -> int = "caml_mpfr_nan_p"
external inf_p : t -> int = "caml_mpfr_inf_p"
external number_p : t -> int = "caml_mpfr_number_p"
external zero_p : t -> int = "caml_mpfr_zero_p"
external regular_p : t -> int = "caml_mpfr_regular_p"
external sgn : t -> int = "caml_mpfr_sgn"
external greater_p : t -> t -> int = "caml_mpfr_greater_p"
external greaterequal_p : t -> t -> int = "caml_mpfr_greaterequal_p"
external less_p : t -> t -> int = "caml_mpfr_less_p"
external lessequal_p : t -> t -> int = "caml_mpfr_lessequal_p"
external equal_p : t -> t -> int = "caml_mpfr_equal_p"
external lessgreater_p : t -> t -> int = "caml_mpfr_lessgreater_p"
external unordered_p : t -> t -> int = "caml_mpfr_unordered_p"
external out_str : int -> int -> t -> rounding -> int = "caml_mpfr_out_str"
external cbrt : t -> t -> rounding -> int = "caml_mpfr_cbrt"
external atan2 : t -> t -> t -> rounding -> int = "caml_mpfr_atan2"
external sec : t -> t -> rounding -> int = "caml_mpfr_sec"
external csc : t -> t -> rounding -> int = "caml_mpfr_csc"
external cot : t -> t -> rounding -> int = "caml_mpfr_cot"
external sech : t -> t -> rounding -> int = "caml_mpfr_sech"
external csch : t -> t -> rounding -> int = "caml_mpfr_csch"
external coth : t -> t -> rounding -> int = "caml_mpfr_coth"
external const_catalan : t -> rounding -> int = "caml_mpfr_const_catalan"
